/** Noten v7
 * Auf mehrere Dateien verteilt
 *  Mit Klassen
 *  Mit Dynamischer Speicherverwaltung,
 *  d.h. Es knnen beliebing viele Noten eingegeben werden **/

#include <iostream>
#include <fstream>
#include <cstdlib>
using namespace std;
#include "notenliste.h"

Note::Note(const string &f,double n)
	:Fach(f),note(n),next(0)
{
}
Note::Note()
	:next(0)
{
}

NotenListe::NotenListe()
 :Noten(0),position(0)
{
}

void NotenListe::removeAll()
{
	Note *p = Noten;
	Noten = 0;
	position =0;
	while(p)
	{
		Note *o = p;
		p = p->next;
		delete o;
	}
}
void NotenListe::schreiben(char* filename)
{
	ofstream out(filename);
	out << "#Notenverwaltung_v5";
	for(Note *p=Noten;p;p = p->next)
		out << '\n' << p->note << "\t" << p->Fach;
	out.close();
}
void NotenListe::lesen(char* filename)
{
	ifstream in(filename);
	string s;
	in >> s;
	if(s!= "#Notenverwaltung_v5") {
		cout << "\nDateiformat nicht untersttzt!\n";
		return ;
	}
	removeAll();
	Noten = new Note();
	position = Noten;
	Note *op;
	while(!in.eof())
	{
		double note;
		string s;
		in >> note >>  s ;
		position->note = note;
		position->Fach = s;
		position->next = new Note();
		op = position;
		position = position->next;
		position->next = 0;
	}
	op->next=0;
	delete position;
	position = op;
}

void NotenListe::einfuegen(Note *n)
{
	if(!Noten)
	{
		Noten = n;
		position = Noten;
		position->next = 0;
	}
	else
	{
		position->next = n;
		position = position->next;
		position->next = 0;
	}
}

void NotenListe::ausgeben()
{
	// Ausgeben
	for(Note *p=Noten;p;p = p->next)
		cout << p->Fach << "\t" << p->note << "\n";
}

double NotenListe::durchschnitt()
{
	// Durchschnitt
	double sum=0.0;
	int c =0;
	for(Note *p=Noten;p;p = p->next)
	{
		sum += p->note;
		c++;
	}
	return sum/c;
}

