#include <iostream>
#include <cstdlib>

using namespace std;

/* Strukturen */

class Date {
 int Tag,Monat,Jahr;
 int Stunde,Minute,Sekunde;
 public:
 void setDate(int t,int m,int j) { Tag=t;Monat=m;Jahr=j; }
 void setTime(int std,int min,int sec) { Stunde=std;Minute=min;Sekunde=sec; }
 void show() {
  cout << Tag << "-" << Monat << "-" << Jahr << " " << Stunde << ":" << Minute << ":" << Sekunde << endl;
 }
};

struct Buchung {
 Buchung *next;
 Date date;
 double sum;
 public:
 Buchung(double sum) { this->sum=sum; }
 void show() {
   cout << sum << "\t";
   date.show();
 }
 friend class Konto;
};

struct Konto {
 Konto *next;
 Buchung *transaktionen;
 double summe;
 string inhaber;
 int nr;
 static uint numKonten;
public:
 Konto(string i)
  :inhaber(i),summe(0),transaktionen(0),next(0)
 {
  nr=++numKonten;
 }
 void show(){
  cout << nr << "\t" << inhaber << "\t" << summe << endl;
 }
 void showAll() {
  cout << "Nr\tName\tGuthaben\n";
  cout << nr << "\t" << inhaber << "\t" << summe << endl;
  cout << endl << "Transaktionen:" << endl;
  cout << "Betrag\tZeitpunkt" << endl;
  for(Buchung *b=transaktionen;b;b=b->next) b->show();
  cout << endl;
 }
 void add(double s)
 {
  add(new Buchung(s));
 }
 void add(Buchung *b){
  b->next = transaktionen;
  transaktionen = b;
  summe += b->sum;
 }
 friend class KontenListe;
};

uint Konto::numKonten = 0;

class KontenListe {
Konto *first;
public:
 KontenListe()
  :first(0)
 {
 }
 void append(Konto *k){
  k->next = first;
  first = k;
 }
 void show() {
  cout << "Nr\tName\tGuthaben\n";
  for(Konto *k=first;k;k=k->next) k->show();
  cout << endl;
 }
 void showAll() {
  for(Konto *k=first;k;k=k->next) k->showAll();
 }
};

int main(int argc, char *argv[])
{
  KontenListe konten;
  Konto *k1 = new Konto("Test1");
  konten.append(k1);
  Buchung *b1 = new Buchung(12.0);
  k1->add(b1);
  Konto *k2 = new Konto("Test2");
  konten.append(k2);
  k2->add(13.0);
  k2->add(-14.4);
  k2->add(23.0);
  konten.show();
  k1->showAll();
  k2->showAll();
  return EXIT_SUCCESS;
}
