#include <iostream>

/* Klassen */

class A
{
 int _value;
protected:
 void setValue(int v) { _value = v;}

public:
 A(int v=0);
 int value() { return _value; }

 void test1() { setValue(12); }
 virtual void test2() { setValue(10); }

};

A::A(int v)
 :_value(v)
{
}

class B : public A
{
 public:
 void test1() { setValue(20);}
};

class C : public B
{
 public:
 void test2() { setValue(30); }
};

class D : public A
{
 public:
 void test2() { setValue(42); }
};

using namespace std;

/* Code */
void testA(A *a)
{
 cout << "A:\n";
 cout << a->value() << "\t";
 a->test1();
 cout << a->value() << "\t";
 a->test2();
 cout << a->value() << "\t";
}

void testB(B *a)
{
 cout << "B:\n";
 cout << a->value() << "\t";
 a->test1();
 cout << a->value() << "\t";
 a->test2();
 cout << a->value() << "\t";
}

void testC(C *a)
{
 cout << "C:\n";
 cout << a->value() << "\t";
 a->test1();
 cout << a->value() << "\t";
 a->test2();
 cout << a->value() << "\t";
}

void testD(D *a)
{
 cout << "D:\n";
 cout << a->value() << "\t";
 a->test1();
 cout << a->value() << "\t";
 a->test2();
 cout << a->value() << "\t";
}

int main()
{
 A a(-8);
 B b;
 C c;
 D d;
 cout << "\na->";
 testA(&a);
 cout << "\nb->";
 testA(&b);
 cout << "\nc->";
 testA(&c);
 cout << "\nd->";
 testA(&d);
 cout << "\nb->";
 testB(&b);
 cout << "\nc->";
 testB(&c);
 cout << "\nc->";
 testC(&c);
 cout << "\nd->";
 testD(&d);
 cout << endl;
 return 0;
}

/* Erzeugt folgendens
a->A:
-8      12      10
b->A:
0       12      10
c->A:
0       12      30
d->A:
0       12      42
b->B:
10      20      10
c->B:
30      20      30
c->C:
30      20      30
d->D:
42      12      42
*/
