#include <iostream>
using namespace std;

class Entry {
 public:
 	Entry *next;
	virtual void show();
};

void Entry::show()
{
 cout << "Sorry, nix zu zeigen" << endl;
}

class List
{
Entry * first;
public:
 List();
 void append(Entry*e);
 void showAll();
};

List::List()
 :first(0)
{
}

void List::append(Entry *e)
{
 e->next=first;
 first = e;
}

void List::showAll()
{
 for(Entry *e=first;e;e=e->next) e->show();
}

// Abgeleitete Klassen

class IntEntry : public Entry {
 int value;
 public:
 IntEntry(int i);
 void show();
};

IntEntry::IntEntry(int i)
 :value(i)
{
}

void IntEntry::show()
{
 cout << value << endl;
}

class AddressEntry : public Entry {
 string name,strasse,ort,plz,tel;
 public:
 AddressEntry(string N,string S,string O,string PLZ,string T);
 void show();
};

AddressEntry::AddressEntry(string N,string S,string O,string PLZ,string T)
 :name(N),strasse(S),ort(O),plz(PLZ),tel(T)
{
}

void AddressEntry::show()
{
 cout << name << endl;
 cout << strasse << endl;
 cout << plz << " " << ort << endl;
 cout << tel << endl;
}

int main()
{
 List l1;
 l1.append(new IntEntry(1));
 for(int i=10;i<20;++i) l1.append(new IntEntry(i));
 List l2;
 l2.append(
  new AddressEntry("Arne Schmitt","Geranienstr.2",
	"Karlsruhe","76185","0721 9850228")
  );
 List l3;
 l3.append(new IntEntry(43));
 l3.append(
  new AddressEntry("Versuch Tester","Versuchsweg 123",
	"Testhausen","12345","0123 456789")
  );
 cout << "l1:" << endl;
 l1.showAll();
 cout << "l2:" << endl;
 l2.showAll();
 cout << "l3:" << endl;
 l3.showAll();
 return 0;
}
